<?php declare(strict_types = 1);

namespace Blog\Model;

use Core\Model\Helpers\BaseEntityService;
use Users\Model\Entities\User;

/**
 * Class Authors
 * @package Blog\Model
 *
 * @method User|null|object = getReference($id)
 * @method User[]|null getAll()
 * @method User|null get($id)
 */
class Authors extends BaseEntityService
{
	protected $entityClass = User::class;

	/**
	 * @param $alias
	 *
	 * @return User|null|object
	 */
	public function findByAlias($alias)
	{
		return $this->getEr()->findOneBy(['alias' => $alias]);
	}
}