<?php declare(strict_types = 1);

namespace Blog\Model\Navigation;

use Blog\Model\Articles;
use Blog\Model\Categories;
use Navigations\Model\Entities\Navigation;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Providers\INavigationItem;
use Nette\Forms\Form;
use Nette\Utils\ArrayHash;
use Nette\Utils\Strings;

class Blog extends BaseNavigation implements INavigationItem
{
	protected $title                  = 'blog';
	protected $presenter              = 'Blog:Front:Default';
	protected $action                 = 'default';
	protected $presenterArticleDetail = 'Blog:Front:Articles';
	protected $actionArticleDetail    = 'detail';

	/** @var Articles */
	protected $articlesService;

	/** @var Categories */
	protected $categoriesService;

	public function __construct(Categories $categories, Articles $articles)
	{
		$this->categoriesService = $categories;
		$this->articlesService   = $articles;
	}

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer()
	{
		$container = new BaseContainer();

		$categories = [];
		foreach ($this->categoriesService->getPublished() as $cat)
			$categories[$cat->getId()] = $cat->title;

		$container->addMultiSelect('categories', 'blog.navigationBuilder.selectCategory', $categories)->getControlPrototype()->attrs['style'] = 'height: 100px';

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		if ($this->presenter == $presenter && $this->action == $action)
			return 1;
		if ($this->presenterArticleDetail == $presenter && $this->actionArticleDetail == $action)
			return 2;

		return false;
	}

	public function routerIn($params, $urlParams = [])
	{
		if (isset($urlParams['path'])) {
			$params = explode('/', $urlParams['path']);
			$id     = explode('-', array_pop($params), 2);

			if (is_numeric($id[0])) {
				return [
					'presenter' => $this->presenterArticleDetail,
					'action'    => $this->actionArticleDetail,
					'id'        => $id[0],
				];
			}
		}

		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => null,
		];
	}

	public function routerOut($navigation, &$params)
	{
		if (isset($params['id'])) {
			$article = $this->articlesService->getArticle($params['id']);
			if ($article)
				return '/' . $navigation->alias . ($article->getCategory()->getId() == 1 ? '' : '/' . $article->getCategory()->alias) . '/' . $article->getId() . '-' . $article->alias;
		}

		$urlParts = [];
		if (!$navigation->isHomepage)
			$urlParts[] = $navigation->alias;

		return '/' . implode('/', $urlParts);
	}
}