<?php declare(strict_types = 1);

namespace Blog\AdminModule\Presenters;

use Blog\AdminModule\Components\Article\IArticlesGridFactory;
use Nette\Http\IResponse;
use Nette\Utils\Html;
use Users\Model\Entities\User;

final class DefaultPresenter extends BasePresenter
{

	/*******************************************************************************************************************
	 * ==================================   Renders
	 */


	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault()
	{
		$this->setTitle($this->translator->translate('blog.title.blog'));
		$this->setHeader('blog.title.blog', 'fa fa-list-alt');
		$this['navigation']->setData(['header' => [
			[
				'title' => 'blog.menu.addArticle',
				'link'  => 'Articles:add',
				'ico'   => 'plus',
			],
		]]);
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentArticlesGrid(IArticlesGridFactory $factory)
	{
		return $factory->create();
	}
}