<?php declare(strict_types = 1);

namespace Blog\FrontModule\Presenters;

use Blog\FrontModule\Components\IArticlesListFactory;
use Blog\Model\Authors;
use Kdyby\Doctrine\EntityManager;
use Nette\Utils\Strings;

final class AuthorPresenter extends BasePresenter
{
	/** @var Authors */
	protected $authorsService;

	/** @var EntityManager @inject */
	public $em;

	public function __construct(Authors $authors)
	{
		$this->authorsService = $authors;
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault($alias)
	{
		if (!$alias || !($author = $this->authorsService->findByAlias($alias)))
			$this->error();

		$this->template->author = $author;
		$this['articlesList']->setAuthor($author->getId());
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentArticlesList(IArticlesListFactory $factory)
	{
		return $factory->create();
	}
}