<?php declare(strict_types = 1);

namespace Blog\Model\Rss;

use Nette\Http\IRequest,
	Nette\Http\IResponse,
	Nette;

/**
 * @property-read \SimpleXMLElement $source
 */
class RssResponse implements \Nette\Application\IResponse
{

	use Nette\SmartObject;

	/** @var \SimpleXMLElement */
	private $source;

	/**
	 * @param \SimpleXMLElement $source
	 */
	function __construct($source)
	{
		$this->source = $source;
	}

	/**
	 * @return \SimpleXMLElement
	 */
	function getSource()
	{
		return $this->source;
	}

	/**
	 * Sends response to output
	 *
	 * @param IRequest  $httpRequest
	 * @param IResponse $httpResponse
	 *
	 * @return void
	 */
	function send(IRequest $httpRequest, IResponse $httpResponse)
	{
		$httpResponse->setContentType('application/xml');
		echo $this->source->asXML();
	}
}