<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Nette\Neon\Neon;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20190913104423 extends AbstractMigration
{
	protected static $articles   = [];
	protected static $categories = [];

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		self::$articles   = $this->connection->fetchAll("SELECT * FROM blog__article");
		self::$categories = $this->connection->fetchAll("SELECT * FROM blog__category");

		$this->addSql('CREATE TABLE blog__article_text (lang VARCHAR(2) NOT NULL, article_id INT NOT NULL, created_by INT DEFAULT NULL, modified_by INT DEFAULT NULL, title VARCHAR(255) NOT NULL, alias VARCHAR(255) NOT NULL, is_published SMALLINT NOT NULL, introtext VARCHAR(255) DEFAULT NULL, `text` LONGTEXT DEFAULT NULL, created DATETIME NOT NULL, modified DATETIME DEFAULT NULL, seo LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', INDEX IDX_A21488037294869C (article_id), INDEX IDX_A2148803DE12AB56 (created_by), INDEX IDX_A214880325F94802 (modified_by), PRIMARY KEY(article_id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE blog__category_text (lang VARCHAR(2) NOT NULL, category_id INT NOT NULL, title VARCHAR(255) NOT NULL, alias VARCHAR(255) NOT NULL, is_published SMALLINT NOT NULL, created DATETIME NOT NULL, INDEX IDX_5B37361712469DE2 (category_id), PRIMARY KEY(category_id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('ALTER TABLE blog__article_text ADD CONSTRAINT FK_A21488037294869C FOREIGN KEY (article_id) REFERENCES blog__article (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE blog__article_text ADD CONSTRAINT FK_A2148803DE12AB56 FOREIGN KEY (created_by) REFERENCES user (id) ON DELETE SET NULL');
		$this->addSql('ALTER TABLE blog__article_text ADD CONSTRAINT FK_A214880325F94802 FOREIGN KEY (modified_by) REFERENCES user (id) ON DELETE SET NULL');
		$this->addSql('ALTER TABLE blog__category_text ADD CONSTRAINT FK_5B37361712469DE2 FOREIGN KEY (category_id) REFERENCES blog__category (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE blog__article DROP FOREIGN KEY FK_23A0E6625F94802');
		$this->addSql('ALTER TABLE blog__article DROP FOREIGN KEY FK_23A0E66DE12AB56');
		$this->addSql('DROP INDEX IDX_22FCB3C25F94802 ON blog__article');
		$this->addSql('DROP INDEX IDX_22FCB3CDE12AB56 ON blog__article');
		$this->addSql('DROP INDEX lang_idx ON blog__article');
		$this->addSql('DROP INDEX publish_idx ON blog__article');
		$this->addSql('ALTER TABLE blog__article DROP created_by, DROP modified_by, DROP title, DROP alias, DROP is_published, DROP introtext, DROP text, DROP created, DROP modified, DROP lang, DROP seo');
		$this->addSql('DROP INDEX lang_idx ON blog__category');
		$this->addSql('DROP INDEX publish_idx ON blog__category');
		$this->addSql('ALTER TABLE blog__category DROP title, DROP alias, DROP is_published, DROP created, DROP lang');
	}

	public function postUp(Schema $schema)
	{
		parent::postUp($schema);

		$configFile  = @file_get_contents(APP_DIR . '/config/app/parameters.neon');
		$appConfig   = Neon::decode($configFile);
		$defaultLang = $appConfig['parameters']['translation']['default'] ?? 'cs';

		foreach (self::$articles as $v) {
			$this->connection->insert('blog__article_text', [
				'article_id'   => $v['id'],
				'lang'         => $v['lang'] ?: $defaultLang,
				'title'        => $v['title'],
				'alias'        => $v['alias'],
				'is_published' => $v['is_published'] ?: 1,
				'introtext'    => $v['introtext'],
				'text'         => $v['text'],
				'created'      => $v['created'],
				'created_by'   => $v['created_by'],
				'modified'     => $v['modified'],
				'modified_by'  => $v['modified_by'],
			]);
		}

		foreach (self::$categories as $v) {
			$this->connection->insert('blog__category_text', [
				'category_id'  => $v['id'],
				'lang'         => $defaultLang,
				'title'        => $v['title'],
				'alias'        => $v['alias'],
				'is_published' => $v['is_published'] ?: 1,
				'created'      => $v['created'],
			]);
		}
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('DROP TABLE blog__article_text');
		$this->addSql('DROP TABLE blog__category_text');
		$this->addSql('ALTER TABLE blog__article ADD created_by INT DEFAULT NULL, ADD modified_by INT DEFAULT NULL, ADD title VARCHAR(255) NOT NULL COLLATE utf8_unicode_ci, ADD alias VARCHAR(255) NOT NULL COLLATE utf8_unicode_ci, ADD is_published SMALLINT NOT NULL, ADD introtext VARCHAR(255) DEFAULT NULL COLLATE utf8_unicode_ci, ADD text LONGTEXT DEFAULT NULL COLLATE utf8_unicode_ci, ADD created DATETIME NOT NULL, ADD modified DATETIME DEFAULT NULL, ADD lang VARCHAR(2) DEFAULT NULL COLLATE utf8_unicode_ci, ADD seo LONGTEXT DEFAULT NULL COLLATE utf8_unicode_ci COMMENT \'(DC2Type:array)\'');
		$this->addSql('ALTER TABLE blog__article ADD CONSTRAINT FK_23A0E6625F94802 FOREIGN KEY (modified_by) REFERENCES user (id) ON UPDATE NO ACTION ON DELETE SET NULL');
		$this->addSql('ALTER TABLE blog__article ADD CONSTRAINT FK_23A0E66DE12AB56 FOREIGN KEY (created_by) REFERENCES user (id) ON UPDATE NO ACTION ON DELETE SET NULL');
		$this->addSql('CREATE INDEX IDX_22FCB3C25F94802 ON blog__article (modified_by)');
		$this->addSql('CREATE INDEX IDX_22FCB3CDE12AB56 ON blog__article (created_by)');
		$this->addSql('CREATE INDEX lang_idx ON blog__article (lang)');
		$this->addSql('CREATE INDEX publish_idx ON blog__article (is_published)');
		$this->addSql('ALTER TABLE blog__category ADD title VARCHAR(255) NOT NULL COLLATE utf8_unicode_ci, ADD alias VARCHAR(255) NOT NULL COLLATE utf8_unicode_ci, ADD is_published SMALLINT NOT NULL, ADD created DATETIME NOT NULL, ADD lang VARCHAR(2) DEFAULT NULL COLLATE utf8_unicode_ci');
		$this->addSql('CREATE INDEX lang_idx ON blog__category (lang)');
		$this->addSql('CREATE INDEX publish_idx ON blog__category (is_published)');
	}
}
