<?php declare(strict_types = 1);

namespace Blog\FrontModule\Presenters;

use Blog\FrontModule\Components\IArticlesListFactory;
use Pages\FrontModule\Model\TemplatePages;
use Pages\Model\Paths;

final class CategoriesPresenter extends BasePresenter
{

	/** @var TemplatePages @inject */
	public $templatePagesService;

	/** @var Paths @inject */
	public $pathsService;

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionCategory($id)
	{
		$this['list']->setCategories([$id]);

		$tpId = $this->getActiveNavigation()->componentParams['tpCategory'];
		if ($tpId) {
			$templatePage = $this->templatePagesService->get((int) $tpId);

			if ($templatePage) {
				$this->template->templateTextValues = $templatePage->getTexts();
				$this->template->setFile($this->pathsService->getTemplatePagesFile($templatePage->getTemplate()));
			}
		}
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentList(IArticlesListFactory $factory)
	{
		$control = $factory->create();

		$control->onAnchor[] = function() use ($control) {
			$page = $control->getParameter('page');

			if ($page > 1) {
				$this['meta']->setMeta('robots', 'noindex,follow');
			}
		};

		return $control;
	}
}
