<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;
use Nette\Utils\Strings;

/**
 * @ORM\Table(name="blog__category_text")
 * @ORM\Entity
 */
class CategoryText
{
	use MagicAccessors;

	/**
	 * @var Category
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Category", inversedBy="texts")
	 * @ORM\JoinColumn(name="category_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $category;

	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2, nullable=true)
	 */
	protected $lang;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255)
	 */
	public $title;

	/**
	 * @var string
	 * @ORM\Column(name="alias", type="string", length=255)
	 */
	protected $alias;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint")
	 */
	public $isPublished;

	/**
	 * @var DateTime
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(name="created", type="datetime")
	 */
	private $created;


	public function __construct(Category $category, string $title, string $lang)
	{
		$this->category = $category;
		$this->title    = $title;
		$this->lang     = $lang;
	}

	public function getTitle(): ?string { return $this->title; }

	public function setTitle(string $title): self
	{
		$this->title = $title;
		if (!$this->alias)
			$this->setAlias($title);

		return $this;
	}

	public function getAlias(): ?string { return $this->alias ?: Strings::webalize($this->title); }

	public function setAlias(string $alias): self
	{
		$this->alias = Strings::webalize($alias);

		return $this;
	}
}
