<?php declare(strict_types = 1);

namespace Blog\Model\Navigation;

use Blog\Model\Articles;
use Blog\Model\Categories;
use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class Search extends BaseNavigation implements INavigationItem
{
	protected $title     = 'search';
	protected $presenter = 'Blog:Front:Default';
	protected $action    = 'search';

	public function __construct()
	{
	}

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer()
	{
		$container = new BaseContainer();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		if ($this->presenter == $presenter && $this->action == $action)
			return 1;

		return false;
	}

	public function routerIn($params, $urlParams = [])
	{
		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => null,
		];
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		if (isset($navigation->componentParams[$urlParams['action']]) && $navigation->componentParams[$urlParams['action']] == $urlParams['id']) {
			return $navigation->alias;
		}

		return null;
	}
}
