<?php declare(strict_types = 1);

namespace Blog\Model\Rss;

use Nette;
use Nette\Utils\DateTime;

class RssChannelItem
{
	use Nette\SmartObject;

	/** @var string */
	protected $title;

	/** @var string */
	protected $description;

	/** @var string */
	protected $link;

	/** @var DateTime */
	protected $pubDate;

	/** @var string */
	protected $image;

	/**
	 * @param string   $title
	 * @param string   $description
	 * @param string   $link
	 * @param DateTime $pubDate
	 * @param string   $image
	 */
	function __construct(string $title, string $description, $pubDate, string $link, string $image)
	{
		$this->title       = $title;
		$this->description = $description;
		$this->link        = $link;
		$this->pubDate     = $pubDate;
		$this->image       = $image;
	}

	/**
	 * @return string
	 */
	function getTitle()
	{
		return $this->title;
	}

	/**
	 * @param string $title
	 */
	function setTitle(string $title)
	{
		$this->title = $title;
	}

	/**
	 * @return string
	 */
	function getDescription()
	{
		return $this->description;
	}

	/**
	 * @param string $description
	 */
	function setDescription(string $description)
	{
		$this->description = $description;
	}

	/**
	 * @return string
	 */
	function getLink()
	{
		return $this->link;
	}

	/**
	 * @param string $link
	 */
	function setLink(string $link)
	{
		$this->link = $link;
	}

	/**
	 * @return DateTime
	 */
	function getPubDate()
	{
		return $this->pubDate;
	}

	/**
	 * @param string $pubDate
	 */
	function setPubDate(string $pubDate)
	{
		$this->pubDate = $pubDate;
	}

	/**
	 * @return string
	 */
	function getImage()
	{
		return $this->image;
	}

	/**
	 * @param string $image
	 */
	function setImage(string $image)
	{
		$this->image = $image;
	}
}