<?php declare(strict_types = 1);

namespace Blog\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Blog\FrontModule\Model\Articles as ArticlesService;
use Blog\FrontModule\Model\Categories as CategoriesService;
use Nette\Localization\ITranslator;

class Articles extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'blogArticles';

	/** @var ArticlesService */
	protected $articlesService;

	/** @var CategoriesService */
	protected $categoriesService;

	/** @var ITranslator */
	protected $translator;

	public function __construct(ArticlesService $articles, CategoriesService $categories, ITranslator $translator)
	{
		$this->articlesService   = $articles;
		$this->categoriesService = $categories;
		$this->translator        = $translator;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$categories = [];
		foreach ($this->categoriesService->getEr()->createQueryBuilder('c')
			         ->select('c.id, ct.lang, ct.title')
			         ->leftJoin('c.texts', 'ct')
			         ->orderBy('ct.title')
			         ->getQuery()->getArrayResult() as $row) {
			if (!isset($categories[$row['id']]) || $row['lang'] === $this->translator->getLocale())
				$categories[$row['id']] = $row['title'];
		}

		$formContainer->addCheckboxList($this->getName(), $this->getTitle(), $categories);
	}

	public function render($params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		$limit = $params['limit'] ?? null;

		return $this->articlesService->getAll($this->getDefault(), null, $limit);
	}
}
