<?php declare(strict_types = 1);

namespace Blog\AdminModule\Model;

use Blog\Model\Entities\Article;
use Core\Model\Helpers\BaseEntityService;
use Nette\Caching\Cache;

class Articles extends BaseEntityService
{
	protected $entityClass = Article::class;

	const CACHE_NAMESPACE = 'articles';

	public function __construct()
	{
	}

	private function getCache()
	{
		if ($this->cache === null)
			$this->cache = new Cache($this->cacheStorage, self::CACHE_NAMESPACE);

		return $this->cache;
	}

	public function invertPublish(int $id, string $lang): bool
	{
		$article = $this->get($id);

		if (!$article || !$article->getText($lang))
			return false;

		$article->getText($lang)->isPublished = !$article->getText($lang)->isPublished;
		$this->em->persist($article->getText($lang))->flush();

		return true;
	}

	public function removeArticle($articleId)
	{
		if ($article = $this->getEr()->find($articleId)) {
			$this->em->remove($article)->flush();

			return true;
		}

		return false;
	}

	public function removeArticles($ids)
	{
		$errors = [];
		foreach ($ids as $id) {
			if (!$this->removeArticle($id))
				$errors[] = $id;
		}

		return $errors;
	}
}
