<?php declare(strict_types = 1);

namespace Blog\AdminModule\Presenters;

use Blog\AdminModule\Components\Article\ArticleForm;
use Blog\AdminModule\Components\Article\IArticleFormFactory;
use Blog\Model\Entities\Article;
use Blog\Model\OpenedArticlesService;
use Core\Components\Flashes\Flashes;
use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;

class ArticlesPresenter extends BasePresenter
{

	/** @var OpenedArticlesService */
	protected $openedArticlesService;

	public function __construct(OpenedArticlesService $openedArticlesService)
	{
		$this->openedArticlesService = $openedArticlesService;
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */
	public function actionAdd(): void
	{
		$this->setHeader('blog.title.newArticle', 'fa fa-list-alt');
	}

	public function actionEdit($id): void
	{
		$article = $this->em->getRepository(Article::class)->find($id);

		if (!$article)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setHeader('blog.title.editArticle', 'fa fa-list-alt');
	}

	public function actionClose($id): void
	{
		$this->openedArticlesService->closeArticle($id);
		$this->redirect('Default:');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */
	protected function createComponentArticleForm(IArticleFormFactory $factory): ArticleForm
	{
		$control = $factory->create();
		if ($this->getParameter('id'))
			$control->setArticle($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function(BaseForm $form, $values) use ($control) {
			$this->flashMessage('blog.articleForm.articleSaved', Flashes::FLASH_SUCCESS);
			bdump($control->article);
			if ($form->isSubmitted()->name == 'submitAndClose')
				$this->redirect('Default:default');
			else {
				$this->redirect('Articles:edit', $control->article->getId());
			}
		};

		return $control;
	}
}
