<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;
use Users\Model\Entities\User;

/**
 * @ORM\Table(name="blog__article_opened")
 * @ORM\Entity
 */
class Opened
{
	use MagicAccessors;

	/**
	 * @var Article
	 * @ORM\Id
	 * @ORM\OneToOne(targetEntity="Article")
	 * @ORM\JoinColumn(name="article_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $article;

	/**
	 * @var User
	 * @ORM\ManyToOne(targetEntity="\Users\Model\Entities\User")
	 * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
	 */
	public $user;

	/**
	 * @var DateTime
	 * @ORM\Column(name="last_activity", type="datetime", nullable=false)
	 */
	public $lastActivity;

	public function __construct($article, $user)
	{
		$this->article      = $article;
		$this->user         = $user;
		$this->lastActivity = new DateTime();
	}
}