<?php declare(strict_types = 1);

namespace Blog\DI;

use Core\DI\CompilerExtension;
use Nette;

class BlogExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		Nette\DI\Compiler::loadDefinitions(
			$this->getContainerBuilder(),
			$this->loadFromFile(__DIR__ . '/services.neon')
		);
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Blog' => 'Blog\*Module\Presenters\*Presenter']);
	}
}