<?php declare(strict_types = 1);

namespace Blog\FrontModule\Components\Article;

use Blog\Model\ArticleHits;
use Blog\FrontModule\Model\Articles;
use Blog\Model\ArticlesFacade;
use Blog\Model\Categories;
use Blog\Model\Entities\Article;
use Core\Model\UI\BaseControl;
use Facebook\FrontModule\Components\ILikeControlFactory;
use Gallery\FrontModule\Components\IGalleryControlFactory;
use Gallery\Model\Albums;
use Nette\Caching\Cache;
use Nette\Http\Request;
use Nette\Http\Session;
use Nette\Http\SessionSection;
use Users\Model\Users;

class ArticleDetail extends BaseControl
{
	/** @var Article */
	protected $article;

	/** @var int */
	protected $page = 1;

	/** @var Articles */
	protected $articlesService;

	/** @var Users */
	protected $usersService;

	/** @var Categories */
	protected $categoriesService;

	/** @var IGalleryControlFactory */
	private $galleryFactory;

	/** @var Session */
	protected $session;

	/** @var SessionSection */
	protected $sessionSection;

	/** @var ILikeControlFactory */
	protected $likeControlFactory;

	/** @var ArticlesFacade */
	protected $articlesFacade;

	public $isLocked = false;
	public $limit    = 9;
	public $start    = 0;

	public function __construct(Articles $articles, Users $users, Categories $categories, IGalleryControlFactory $galleryFactory, ILikeControlFactory $likeControlFactory, Session $session, ArticlesFacade $articlesFacade)
	{
		$this->articlesService   = $articles;
		$this->galleryFactory    = $galleryFactory;
		$this->usersService      = $users;
		$this->categoriesService = $categories;
		$this->session           = $session;
		$this->sessionSection    = $session->getSection('categories');
		$this->sessionSection->setExpiration('1 month', 'unlocked');
		$this->likeControlFactory = $likeControlFactory;
		$this->articlesFacade     = $articlesFacade;
	}

	protected function attached($presenter)
	{
		parent::attached($presenter);
		$this->cache = new Cache($this->cacheStorage, Articles::CACHE_NAMESPACE);
	}

	public function render()
	{
		if (!$this->article)
			return '';

		if ($this->article->getCategory()->password != null
			&& !($this->sessionSection->unlocked && in_array($this->article->getCategory()->getId(), $this->sessionSection->unlocked))
		) {
			$this->isLocked = true;
			$this->template->setFile(__DIR__ . '/password.latte');
			$this->template->render();
		} else {
			$this->isLocked = false;
			$this->articlesService->addShow($this->article->getId());

			$this->template->article      = $this->article;
			$this->template->nextArticles = function() { return $this->getNextArticles(); };
			$this->template->prevArticles = function() { return $this->getPrevArticles(); };
			$this->template->backLink     = $this->getPresenter()->navigationsService->generateLink($this->getPresenter()->getActiveNavigation());

			$this->template->render($this->getTemplateFile());
		}
	}

	public function setArticle($article)
	{
		$this->article = $article instanceof Article ? $article : $this->articlesService->get($article);
		if ($this->article->getCategory()->password != null
			&& !($this->sessionSection->unlocked && in_array($this->article->getCategory()->getId(), $this->sessionSection->unlocked))
		) {
			$this->isLocked = true;
		} else {
			$this->isLocked = false;
		}
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */
	protected function createComponentGallery()
	{
		$control = $this->galleryFactory->create();
		if ($this->article->gallery)
			$control->setAlbum($this->article->gallery->getId());

		return $control;
	}

	protected function createComponentCategoryPasswordForm()
	{
		$form = $this->createForm();

		$form->addPassword('password', 'blog.categoryPasswordForm.password')->setRequired()
			->setPlaceholder($this->t('blog.categoryPasswordForm.password'));
		$form->addSubmit('submit', 'blog.categoryPasswordForm.unlock');

		$form->onSubmit[] = function($form) {
			$values = $form->getValues();

			if ($this->article->getCategory()->password == $values->password) {
				if (!is_array($this->sessionSection->unlocked))
					$this->sessionSection->unlocked = [];
				$this->sessionSection->unlocked[] = $this->article->getCategory()->getId();
			}

			$this->redirect('this');
		};

		return $form;
	}

	protected function createComponentLikeControl()
	{
		return $this->likeControlFactory->create();
	}

	public function getNextArticles()
	{
		return $this->articlesService->getNextPublishedArticle($this->article, $this->presenter->getActiveNavigation()->componentParams['category'] ?? null);
	}

	public function getPrevArticles()
	{
		return $this->articlesService->getPrevPublishedArticle($this->article, $this->presenter->getActiveNavigation()->componentParams['category'] ?? null);
	}
}
