<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use Core\Model\Entities\TLang;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;
use Nette\Utils\Strings;

/**
 * @ORM\Table(name="blog__category", indexes={@ORM\Index(name="publish_idx", columns={"is_published"}),@ORM\Index(name="lang_idx", columns={"lang"})})
 * @ORM\Entity
 */
class Category
{
	use Identifier;
	use MagicAccessors;
	use TLang;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255)
	 */
	public $title;

	/**
	 * @var string
	 * @ORM\Column(name="alias", type="string", length=255)
	 */
	protected $alias;

	/** @var string
	 * @ORM\Column(name="layout", type="string", length=60)
	 */
	protected $layout;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint")
	 */
	public $isPublished;

	/**
	 * @var string
	 * @ORM\Column(name="password", type="string", length=60, nullable=true)
	 */
	protected $password;

	/**
	 * @var Category[];
	 * @ORM\OneToMany(targetEntity="Category", mappedBy="parent")
	 */
	protected $childrens;

	/**
	 * @var Category
	 * @ORM\ManyToOne(targetEntity="Category", inversedBy="childrens")
	 * @ORM\JoinColumn(name="parent_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	protected $parent;

	/**
	 * @var DateTime
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(name="created", type="datetime")
	 */
	private $created;

	public function __construct($title)
	{
		$this->title = $title;
		$this->setAlias($title);
		$this->layout      = 'default';
		$this->isPublished = 1;
		$this->childrens   = new ArrayCollection();
	}

	public function setAlias($alias)
	{
		$this->alias = Strings::webalize($alias);
	}

	public function setPassword($password)
	{
		$this->password = $password ?: null;
		//		if ($password != '*****')
		//			$this->password = (!$password) ? null : Passwords::hash($password);
	}

	public function isLocked() { return $this->password ? true : false; }

	public function getLayout() { return $this->layout ?: 'default'; }
}