<?php declare(strict_types = 1);

namespace Blog\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Blog\FrontModule\Model\Articles as ArticlesService;
use Blog\FrontModule\Model\Categories as CategoriesService;

class Articles extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'blogArticles';

	/** @var ArticlesService */
	protected $articlesService;

	/** @var CategoriesService */
	protected $categoriesService;

	public function __construct(ArticlesService $articles, CategoriesService $categories)
	{
		$this->articlesService   = $articles;
		$this->categoriesService = $categories;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$categories = [];
		foreach ($this->categoriesService->getEr()->findBy([], ['title' => 'ASC']) as $c) {
			$categories[$c->getId()] = $c->title;
		}

		$formContainer->addCheckboxList($this->getName(), $this->getTitle(), $categories);
	}

	public function render($params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		$limit = $params['limit'] ?? null;

		return $this->articlesService->getAll($this->getDefault(), null, $limit);
	}
}