<?php declare(strict_types = 1);

namespace Blog\AdminModule\Components\Category;

use Blog\Model\Entities\Category;
use Blog\Model\UI;
use Core\Model\Lang\Langs;
use Core\Model\UI\BaseControl;
use Nette\Forms\Form;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use Nette\Utils\Strings;

class CategoryForm extends BaseControl
{
	/** @var Category */
	public $category;

	/** @var UI\Category\Renderer */
	protected $categoryRenderer;

	public function __construct(UI\Category\Renderer $categoryRenderer)
	{
		$this->categoryRenderer = $categoryRenderer;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$layouts = [];
		foreach ($this->categoryRenderer->getLayouts() as $k => $v)
			$layouts[$k] = $v->name;

		$form->addText('title', 'blog.categoryForm.title')->setRequired()->setMaxLength(255);
		$form->addText('alias', 'blog.categoryForm.alias')->setMaxLength(255);
		$form->addSelect('layout', 'blog.categoryForm.layout', $layouts);
		$form->addText('password', 'blog.categoryForm.password');
		$form->addBool('isPublished', 'blog.categoryForm.isPublished')->setDefaultValue(1);
		$form->addLangsSelect('lang', 'default.language');
		//		$form->addSelect('parent', $this->t('blog.categoryForm.parent'), $categories)->setTranslator(null);

		$form->addSubmit('submit', 'default.save');

		if ($this->category) {
			$category = $this->category;
			$form->setDefaults([
				'title'       => $category->title,
				'alias'       => $category->alias,
				'password'    => $category->password,
				'isPublished' => $category->isPublished,
				//				'parent'      => $category->parent ? $category->parent->getId() : null,
			]);

			if (array_key_exists($category->layout, $layouts))
				$form['layout']->setDefaultValue($category->layout);

			if (array_key_exists($category->getLangId(), $form['lang']->getItems()))
				$form['lang']->setDefaultValue($category->getLangId());
		}

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(Form $form, ArrayHash $values)
	{
		try {
			$category = $this->category ?: new Category($values->title);

			$category->title       = $values->title;
			$category->layout      = $values->layout;
			$category->alias       = $values->alias ?: Strings::webalize($values->title);
			$category->isPublished = $values->isPublished;
			//			$category->parent      = $values->parent ? $this->em->getReference(Category::class, $values->parent) : null;
			$category->setPassword($values->password);
			$category->setLang($values->lang);

			$this->em->persist($category);
			$this->em->flush();
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setCategory($id)
	{
		$this->category = $this->em->getRepository(Category::class)->find($id);

		if (!$this->category)
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
