<?php declare(strict_types = 1);

namespace Blog\AdminModule\Presenters;

use Blog\AdminModule\Components\Article\IArticleFormFactory;
use Blog\Model\Entities\Article;
use Blog\Model\OpenedArticlesService;
use Core\Components\Flashes\Flashes;
use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use Nette\Utils\Html;

final class ArticlesPresenter extends BasePresenter
{

	/** @var OpenedArticlesService */
	protected $openedArticlesService;

	public function __construct(OpenedArticlesService $openedArticlesService)
	{
		$this->openedArticlesService = $openedArticlesService;
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */
	public function actionAdd()
	{
		$this->setTitle($this->translator->translate('blog.title.newArticle'));
		$this->setHeader('blog.title.newArticle', 'fa fa-list-alt');
	}

	public function actionEdit($id)
	{
		$article = $this->em->getRepository(Article::class)->find($id);

		if (!$article)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('blog.title.editArticle'), $article->title);
		$this->setHeader('blog.title.newArticle', 'fa fa-list-alt');
	}

	public function actionClose($id)
	{
		$this->openedArticlesService->closeArticle($id);
		$this->redirect('Default:');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */
	protected function createComponentArticleForm(IArticleFormFactory $factory)
	{
		$control = $factory->create();
		if ($this->getParameter('id'))
			$control->setArticle($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function(BaseForm $form, $values) {
			$this->flashMessage('blog.articleForm.articleSaved', Flashes::FLASH_SUCCESS);

			if ($form->isSubmitted()->name == 'submitAndClose')
				$this->redirect('Default:default');
			else {
				$this->redirect('Articles:edit', $values->articleId);
			}
		};

		return $control;
	}
}