<?php declare(strict_types = 1);

namespace Blog\AdminModule\Presenters;

use Blog\AdminModule\Components\Category\ICategoriesGridFactory;
use Blog\AdminModule\Components\Category\ICategoryFormFactory;
use Blog\Model\Entities\Category;
use Nette\Http\IResponse;

final class CategoriesPresenter extends BasePresenter
{

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault()
	{
		$this->setTitle($this->translator->translate('blog.title.categories'));
		$this->setHeader('blog.title.categories', 'fa fa-list');

		$this['navigation']->setData(['header' => [
			[
				'title' => 'blog.menu.addCategory',
				'link'  => 'Categories:add',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAdd()
	{
		$this->setTitle($this->translator->translate('blog.title.newCategory'));
		$this->setHeader('blog.title.newCategory', 'fa fa-list');
	}

	public function actionEdit($id)
	{
		$category = $this->em->getRepository(Category::class)->find($id);

		if (!$category)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('blog.title.editCategory'), $category->title);
		$this['header']->setTitle($this->translator->translate('blog.title.editCategory'));
		$this->setHeader('blog.title.editCategory', 'fa fa-list');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentCategoryForm(ICategoryFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setCategory($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function() {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentCategoriesGrid(ICategoriesGridFactory $factory)
	{
		return $factory->create();
	}
}
