<?php declare(strict_types = 1);

namespace Blog\FrontModule\Components\Article;

use Blog\Model\Articles;
use Blog\Model\MostRead;
use Core\Model\UI\BaseControl;

class MostReadControl extends BaseControl
{
	/** @var MostRead */
	protected $mostReadService;

	public function __construct(MostRead $mostRead)
	{
		$this->mostReadService    = $mostRead;
	}

	public function render()
	{
		try {
			$this->template->cacheNamespace = Articles::CACHE_NAMESPACE;
			$this->template->articles       = $this->mostReadService->getMostRead();
			$this->template->setFile(__DIR__ . '/MostReadControl.latte');
			$this->template->render();
		} catch(\Exception $e) {

		}
	}

	/*******************************************************************************************************************
	 * ========================  Components
	 */
}
