<?php declare(strict_types = 1);

namespace Blog\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Blog\FrontModule\Model\Articles as ArticlesService;
use Blog\FrontModule\Model\Categories as CategoriesService;

class ArticleFromCategory extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'articleFromCategory';

	/** @var ArticlesService */
	protected $articlesService;

	/** @var CategoriesService */
	protected $categoriesService;

	public function __construct(ArticlesService $articles, CategoriesService $categories)
	{
		$this->articlesService = $articles;
		$this->categoriesService = $categories;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$articles = ['' => null];
		$category = $this->categoriesService->get($params['category']);
		$this->articlesService->getEr()->findBy(['category' => $category]);
		foreach ($this->articlesService->getEr()->findBy(['category' => $category]) as $a) {
			$articles[$a->getId()] = $a->title;
		}

		$formContainer->addSelect($this->getName(), $this->getTitle(), $articles);
	}

	public function render($params)
	{

		$limit = $params['limit'] ?? null;

		return $this->articlesService->get($this->getDefault(), null, $limit);
	}
}
