<?php declare(strict_types = 1);

namespace Blog\Model;

use Doctrine\Common\Collections\ArrayCollection;
use Gallery\Model\Albums;
use Gallery\Model\Images;

class ArticlesFacade
{
	/** @var Articles */
	protected $articlesService;

	/** @var Albums */
	protected $albumsService;

	/** @var Images */
	protected $imagesService;

	public function __construct(Articles $articles, Albums $albums, Images $images)
	{
		$this->articlesService = $articles;
		$this->albumsService   = $albums;
		$this->imagesService   = $images;
	}

	/**
	 * Load data for articlesList
	 *
	 * @param $ids
	 *
	 * @return Entities\Article[]|null
	 */
	public function getArticlesIntro($ids)
	{
		$articles = $this->articlesService->getPublishedById($ids);

		if ($articles) {
			$galleryIds = [];
			foreach ($articles as $a) {
				if ($a->getGallery()) {
					$galleryIds[] = $a->getGallery()->getId();
				}
			}

			$albums = $this->albumsService->getPublishedById($galleryIds);

			if ($albums) {
				$images = $this->imagesService->getPublishedByAlbumId($galleryIds);

				foreach ($images as $img) {
					$albumId = $img->getAlbum()->getId();
					if ($img->isCover) {
						$albums[$albumId]->setCover($img);
					} else if (!$albums[$albumId]->getCoverRaw()) {
						$albums[$albumId]->setCover($img);
					} else if ($albums[$albumId]->getCoverRaw() && !$albums[$albumId]->getCoverRaw()->isCover) {
						if ($albums[$albumId]->getCoverRaw()->getPosition() > $img->getPosition())
							$albums[$albumId]->setCover($img);
					}
				}
			}
		}

		return $articles;
	}
}