<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="blog__category")
 * @ORM\Entity
 * @ORM\EntityListeners({"CategoryListener", "Core\Model\Entities\TranslateListener"})
 */
class Category
{
	use Identifier;
	use MagicAccessors;
	use TTranslateListener;

	/** @var string
	 * @ORM\Column(name="layout", type="string", length=60)
	 */
	protected $layout;

	/**
	 * @var string
	 * @ORM\Column(name="password", type="string", length=60, nullable=true)
	 */
	protected $password;

	/**
	 * @var Category[];
	 * @ORM\OneToMany(targetEntity="Category", mappedBy="parent")
	 */
	protected $childrens;

	/**
	 * @var Category
	 * @ORM\ManyToOne(targetEntity="Category", inversedBy="childrens")
	 * @ORM\JoinColumn(name="parent_id", referencedColumnName="id", onDelete="SET NULL")
	 */
	protected $parent;

	/**
	 * @var CategoryText[]
	 * @ORM\OneToMany(targetEntity="CategoryText", mappedBy="category", indexBy="lang")
	 */
	protected $texts;

	public function __construct()
	{
		$this->texts     = new ArrayCollection();
		$this->layout    = 'default';
		$this->childrens = new ArrayCollection();
	}

	public function setPassword($password)
	{
		$this->password = $password ?: null;
		//		if ($password != '*****')
		//			$this->password = (!$password) ? null : Passwords::hash($password);
	}

	public function isLocked() { return $this->password ? true : false; }

	public function getLayout() { return $this->layout ?: 'default'; }

	public function setLayout(string $layout): self
	{
		$this->layout = $layout;

		return $this;
	}

	public function setTexts(array $texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}

	public function getText(?string $lang = null): ?CategoryText { return $this->texts[$lang ?: $this->locale] ?? null; }

	/** @return CategoryText[]|ArrayCollection */
	public function getTexts() { return $this->texts; }
}
