<?php declare(strict_types = 1);

namespace Blog\Model;

use Core\Model\Helpers\BaseService;
use Nette\Caching\Cache;

class MostRead extends BaseService
{
	/** @var bool */
	public $useGa = false;

	/** @var Articles */
	protected $articlesService;

	public function __construct(Articles $articles)
	{
		$this->articlesService = $articles;
	}

	private function getCache()
	{
		if ($this->cache === null)
			$this->cache = new Cache($this->cacheStorage, Articles::CACHE_NAMESPACE);

		return $this->cache;
	}

	public function getMostRead()
	{
		$articles = [];
		$key      = Articles::CACHE_NAMESPACE . '/featured';

		//		$mostRead = $this->getCache()->load($key, function(&$dep) use ($key) {
		//			$dep = [Cache::TAGS => [$key, Articles::CACHE_NAMESPACE], Cache::EXPIRE => '5 minutes'];

		$mostRead = $this->articlesService->getMostRead(4);

		$mostRead = array_map(function($article) { return $article['articleId']; }, $mostRead);
		//		});

		foreach ($mostRead as $id) {
			$article = $this->articlesService->getReference($id);

			if ($article)
				$articles[] = $article;

			if (count($articles) >= 4)
				break;
		}

		return $articles;
	}
}