<?php declare(strict_types = 1);

namespace Blog\FrontModule\Model;

use Blog\Model\Entities\Category;
use Core\Model\Helpers\BaseFrontEntityService;
use Nette\Caching\Cache;
use Blog\FrontModule\Model\Dao;

/**
 * Class Categories
 * @package Blog\FrontModule\Model
 */
class Categories extends BaseFrontEntityService
{
	/** @var string */
	protected $entityClass = Category::class;

	protected $cCategories;

	const CACHE_NAMESPACE = 'categories';

	protected $cacheDep = [
		Cache::TAGS    => ['categories'],
		Cache::EXPIRE  => '1 month',
		Cache::SLIDING => true,
	];


	public function __construct()
	{
	}

	protected function getCache()
	{
		if ($this->cache === null)
			$this->cache = new Cache($this->cacheStorage, self::CACHE_NAMESPACE);

		return $this->cache;
	}

	/**
	 * @param int $id
	 *
	 * @return Dao\Category|null
	 */
	public function get(int $id)
	{
		return $this->getAll()[$id] ?? null;
	}

	/**
	 * @return Dao\Category[]
	 */
	public function getAll(): array
	{
		$key = 'categories/' . $this->translator->getLocale();

		if (!$this->cCategories[$key]) {
			$this->cCategories[$key] = $this->getCache()->load($key, function(&$dep) {
				$categories = [];

				foreach ($this->getEr()->createQueryBuilder('c')
					         ->addSelect('ct')
					         ->innerJoin('c.texts', 'ct')
					         ->getQuery()->getArrayResult() as $row) {
					$text = $row['texts'][$this->translator->getLocale()];

					$dao        = new Dao\Category();
					$dao->id    = $row['id'];
					$dao->lang  = $this->translator->getLocale();
					$dao->title = $text['title'];
					$dao->alias = $text['alias'];

					$categories[$row['id']] = $dao;
				}

				return $categories;
			});
		}

		return $this->cCategories[$key] ?: [];
	}
}
