<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use Core\Model\Entities\TLang;
use Core\Model\Entities\TSeo;
use Core\Model\Lang\Langs;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gallery\Model\Entities\Album;
use Gallery\Model\Entities\Image;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;
use Nette\Utils\Strings;
use SimpleHtmlDom\simple_html_dom;
use Tags\Model\Entities\Tag;
use Users\Model\Entities\User;

/**
 * Class Article
 * @package Blog\Model\Entities
 *
 * @ORM\Table(name="blog__article_text")
 * @ORM\Entity
 */
class ArticleText
{
	use MagicAccessors;
	use TSeo;

	/**
	 * @var Article
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Article", inversedBy="texts")
	 * @ORM\JoinColumn(name="article_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $article;

	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2, nullable=true)
	 */
	protected $lang;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255)
	 */
	protected $title;

	/**
	 * @var string
	 * @ORM\Column(name="alias", type="string", length=255)
	 */
	protected $alias;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint")
	 */
	public $isPublished;

	/**
	 * @var string
	 * @ORM\Column(name="introtext", type="string", nullable=true)
	 */
	public $introtext;

	/**
	 * @var string
	 * @ORM\Column(name="`text`", type="text", nullable=true)
	 */
	public    $fulltext;
	protected $preparedFulltext;

	/**
	 * @var DateTime
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(name="created", type="datetime")
	 */
	private $created;

	/**
	 * @var User
	 * @ORM\ManyToOne(targetEntity="\Users\Model\Entities\User")
	 * @ORM\JoinColumn(name="created_by", referencedColumnName="id", onDelete="SET NULL")
	 */
	public $createdBy;

	/**
	 * @var DateTime
	 * @Gedmo\Timestampable(on="update")
	 * @ORM\Column(name="modified", type="datetime", nullable=true)
	 */
	private $modified;

	/**
	 * @var User
	 * @ORM\ManyToOne(targetEntity="\Users\Model\Entities\User")
	 * @ORM\JoinColumn(name="modified_by", referencedColumnName="id", nullable=true, onDelete="SET NULL")
	 */
	public $modifiedBy;

	public function __construct(Article $article, string $title, string $lang)
	{
		$this->article = $article;
		$this->title   = $title;
		$this->lang    = $lang;
	}

	public function getTitle(): ?string { return $this->title; }

	public function setTitle(string $title): self
	{
		$this->title = $title;
		if (!$this->alias)
			$this->setAlias($title);

		return $this;
	}

	public function getAlias(): ?string { return $this->alias ?: Strings::webalize($this->title); }

	public function setAlias(string $alias): self
	{
		$this->alias = Strings::webalize($alias);

		return $this;
	}

	public function getCreated(): \DateTime { return $this->created; }

	public function getModified(): \DateTime { return $this->modified; }
}
