<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use Blog\Model\Categories;
use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Events\Subscriber;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\Http\Session;
use Nette\SmartObject;

class CategoryListener implements Subscriber
{
	use SmartObject;

	/** @var int */
	protected static $i = 0;

	/** @var Cache */
	protected $cache;

	/** @var Cache */
	protected $navigationCache;

	/** @var Session */
	protected $session;

	protected $fields = false;

	public function __construct(IStorage $cacheStorage, Session $session)
	{
		$this->session         = $session;
		$this->cache           = new Cache($cacheStorage, Categories::CACHE_NAMESPACE);
		$this->navigationCache = new Cache($cacheStorage, Navigations::CACHE_NAMESPACE);
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PostPersist
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 *
	 * @param Category           $category
	 * @param LifecycleEventArgs $event
	 */
	public function postHandler(Category $category, LifecycleEventArgs $event)
	{
		foreach ($category->getTexts()->getKeys() as $l) {
			$this->cache->remove('categories/' . $l);
		}

		$this->navigationCache->clean([Cache::TAGS => 'articles']);
	}
}
