<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;

/**
 * @ORM\Table(name="blog__article_hits")
 * @ORM\Entity
 */
class Hit
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var Article
	 * @ORM\ManyToOne(targetEntity="Article")
	 * @ORM\JoinColumn(name="article_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $article;

	/**
	 * @var int
	 * @ORM\Column(name="shows", type="integer", options={"unsigned"=true})
	 */
	public $shows;

	/**
	 * @var DateTime
	 * @ORM\Column(name="date", type="date")
	 */
	public $date;

	public function __construct($article, $date = null)
	{
		$this->article = $article;
		$this->shows   = 0;
		$this->date    = $date instanceof DateTime ? $date : new DateTime();
	}
}