<?php declare(strict_types = 1);

namespace Blog\FrontModule\Components\Article;

use Blog\Model\Articles;
use Blog\Model\Entities\Article;
use Core\Model\UI\BaseControl;

class Featured extends BaseControl
{
	/** @var Article */
	protected $article;

	/** @var Articles */
	protected $articlesService;

	public function __construct(Articles $articles)
	{
		$this->articlesService    = $articles;
	}

	protected function attached($presenter)
	{
		parent::attached($presenter);
		$this->article = $this->articlesService->getFeatured();
	}

	public function render()
	{
		if (!$this->article)
			return;

		$this->template->cacheNamespace = Articles::CACHE_NAMESPACE;
		$this->template->cacheKey       = Articles::CACHE_NAMESPACE . '/featured/' . $this->translator->getLocale() . '/r';
		$this->template->cacheKey2      = Articles::CACHE_NAMESPACE . '/featured';
		$this->template->article        = $this->article;
		$this->template->setFile($this->getTemplateFile());
		$this->template->render();
	}

	public function getArticle() { return $this->article; }

	/*******************************************************************************************************************
	 * ============================== Components
	 */
}
