<?php declare(strict_types = 1);

namespace Blog\FrontModule\Presenters;

use Blog\FrontModule\Components\IArticlesListFactory;

final class CategoriesPresenter extends BasePresenter
{

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionCategory($id)
	{
		$this['list']->setCategories([$id]);
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentList(IArticlesListFactory $factory)
	{
		$control = $factory->create();

		$control->onAnchor[] = function() use ($control) {
			$page = $control->getParameter('page');

			if ($page > 1) {
				$this['meta']->setMeta('robots', 'noindex,follow');
			}
		};

		return $control;
	}
}