<?php declare(strict_types = 1);

namespace Blog\FrontModule\Presenters;

use Blog\Model\Articles;
use Blog\Model\Categories;
use Blog\Model\Entities\Article;
use Blog\Model\Rss\Collection;
use Blog\Model\Rss\Generator;
use Blog\Model\Rss\RssChannelItem;
use Nette\Utils\DateTime;
use Nette\Utils\Strings;

final class RssPresenter extends BasePresenter
{
	/** @var Articles */
	protected $articlesService;

	public function __construct(Articles $articles)
	{
		$this->articlesService = $articles;
	}

	/*******************************************************************************************************************
	 * ==================================   Renders
	 */


	/*******************************************************************************************************************
	 * ==================================   Actions
	 */
	public function actionDefault()
	{
		$generator = new Generator();
		$generator->setTitle($this->optionsService->get('site_title'));
		$generator->setDescription($this->optionsService->get('site_description') ?: ' ');
		$generator->setLink($this->link('//index.php'));
		$generator->setLastBuildDate(new DateTime());
		$generator->setDateTimeFormat(DATE_RFC822);
		$generator->setShortenDescription(300);
		$generator->setDataSource(function()  {
			$items = [];
			/** @var Article[]|null $articles */
			$articles = $this->articlesService->getPublishedArticlesQuery()
				->orderBy('a.publishUp', 'DESC')->setMaxResults(20)->getQuery()->getResult();
			foreach ($articles as $article) {
				;
				$item = new RssChannelItem($article->title, $article->getIntrotext(), $article->publishUp, $this->link('//:Blog:Front:Articles:detail', [$article->getId()]), $this->baseUrl . ltrim($article->getImageFile(), '/'));

				$items[] = $item;
			}

			return $items;
		});

		$this->sendResponse($generator->response());
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */
}