<?php declare(strict_types = 1);

namespace Blog\Model;

use Blog\Model\Entities\Category;
use Core\Model\Helpers\BaseEntityService;

/**
 * Class Categories
 * @package Blog\Model
 *
 * @method Category|null|object = getReference($id)
 * @method Category[]|null getAll()
 * @method Category|null get($id)
 */
class Categories extends BaseEntityService
{
	protected $entityClass = Category::class;

	const CACHE_NAMESPACE = 'categories';

	public function getPublishedQuery()
	{
		return $this->getEr()->createQueryBuilder('c')->andWhere('c.isPublished = 1');
	}

	public function getPublished()
	{
		return $this->getPublishedQuery()->getQuery()->getResult();
	}

	/**
	 * @param $id
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function removeCategory($id)
	{
		try {
			if ($category = $this->getEr()->find($id)) {
				$this->em->remove($category);
				$this->em->flush();

				return true;
			}
		} catch (\Exception $e) {
		}

		return false;
	}
}
