<?php declare(strict_types = 1);

namespace Blog\Model;

use Blog\Model\Entities\Article;
use Blog\Model\Entities\Hit;
use Blog\Model\Entities\Hit2;
use Core\Model\Helpers\BaseEntityService;
use Nette\Utils\DateTime;

/**
 * Použít pokud budou potřeba podrobnější statistiky
 *
 * Class ArticleHits
 * @package Blog\Model
 *
 * @method Hit|null|object = getReference($id)
 * @method Hit[]|null getAll()
 * @method Hit|null get($id)
 */
class ArticleHits extends BaseEntityService
{
	protected $entityClass = Hit::class;

	public function getCurrentByArticle($article)
	{
		$article = $article instanceof Article ? $article : $this->em->getReference(Article::class, $article);
		$today   = new DateTime;
		$stat    = $this->getEr()->findOneBy(['article' => $article->getId(), 'date' => $today]);
		if (!$stat) {
			$stat = new Hit($article, $today);
			$this->em->persist($stat);
			$this->em->flush();
		}

		return $stat;
	}

	public function addShow($articleId)
	{
		try {
			$stat = $this->getCurrentByArticle($articleId);
			$this->getEr()->createQuery('UPDATE ' . Hit::class . ' h SET h.shows = h.shows + 1 WHERE h.id = :id')
				->setParameters([':id' => $stat->getId()])->execute();
		} catch (\Exception $e) {
		}
	}

	public function getSumByArticles($ids)
	{
		$result = [];
		foreach ($this->getEr()->createQueryBuilder('h')
			         ->where(is_array($ids) ? 'h.article IN (:ids)' : 'h.article = :ids')->setParameter('ids', $ids)
			         ->getQuery()->getResult() as $row) {
			if (!isset($result[$row->article->getId()]))
				$result[$row->article->getId()] = 0;
			$result[$row->article->getId()] += $row->shows;
		}

		return $result;
	}
}