<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use Blog\Model\Articles;
use Blog\Model\Navigation\Blog;
use Core\Model\Images\ImagePipe;
use Doctrine;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Events\Subscriber;
use Navigations\Model\Navigations;
use Nette\Application\LinkGenerator;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\Http\Session;
use Nette\SmartObject;

class ArticleListener implements Subscriber
{
	use SmartObject;

	/** @var int */
	protected static $i = 0;

	/** @var Cache */
	protected $cache;

	/** @var Cache */
	protected $navigationCache;

	/** @var Session */
	protected $session;

	protected $fields = false;

	public function __construct(IStorage $cacheStorage, Session $session)
	{
		$this->session         = $session;
		$this->cache           = new Cache($cacheStorage, Articles::CACHE_NAMESPACE);
		$this->navigationCache = new Cache($cacheStorage, Navigations::CACHE_NAMESPACE);
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PreRemove
	 *
	 * @param Article                               $article
	 * @param Doctrine\ORM\Event\LifecycleEventArgs $event
	 */
	public function onPreRemove($article, $event)
	{
		$sessionSection = $this->session->getSection('unsavedArticles');
		unset($sessionSection->{'article_' . $article->getId()});
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param Article                              $article
	 * @param Doctrine\ORM\Event\PreFlushEventArgs $event
	 */
	public function onPreFlush($article, $event)
	{
		$cleanTags = [
			Articles::CACHE_NAMESPACE . '/article/' . $article->getId(),
		];

		if ($article->getIsFeatured()) {
			$cleanTags[] = Articles::CACHE_NAMESPACE . '/featured';
			$cleanTags[] = Articles::CACHE_NAMESPACE . '/featured/' . ($article->getLangId() ?: $article->getCategory()->getLangId());
		}

		$this->cache->clean([Cache::TAGS => $cleanTags]);

		$this->navigationCache->clean([
			Cache::TAGS => [
				Blog::CACHE_ARTICLE . '/' . $article->getId(),
			],
		]);
	}
}
