<?php declare(strict_types = 1);

namespace Blog\Model\UI\Category;

use Core\Model\Helpers\BaseService;
use Nette\Utils\ArrayHash;

class Renderer extends BaseService
{
	/** @var array */
	protected $params;

	/** @var ArrayHash */
	protected $layouts;

	public function __construct($params)
	{
		$this->params = ArrayHash::from($params);
	}

	/**
	 * Return array of available layouts
	 *
	 * @return mixed
	 */
	public function getLayouts()
	{
		if ($this->layouts === null) {
			foreach ($this->params->layouts as $k => $v)
				$this->layouts[$k]['name'] = $this->t($v->name);
			$this->layouts = ArrayHash::from($this->layouts);
		}

		return $this->layouts;
	}
}
