<?php declare(strict_types = 1);

namespace Blog\AdminModule\Presenters;

use Blog\AdminModule\Components\Article\ArticleForm;
use Blog\AdminModule\Components\Article\IArticleFormFactory;
use Blog\Model\Entities\Article;
use Blog\Model\OpenedArticlesService;
use Core\Model\UI\Form\BaseForm;
use Nette\Application\AbortException;
use Nette\Application\BadRequestException;

class ArticlesPresenter extends BasePresenter
{
	public function __construct(protected OpenedArticlesService $openedArticlesService)
	{
		parent::__construct();
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */
	public function actionAdd(): void
	{
		$this->setHeader('blog.title.newArticle', 'fa fa-list-alt');
	}

	/**
	 * @throws BadRequestException
	 */
	public function actionEdit(int|string $id): void
	{
		$article = $this->em->getRepository(Article::class)->find($id);

		if (!$article) {
			$this->error();
		}

		$this->setHeader('blog.title.editArticle', 'fa fa-list-alt');
	}

	/**
	 * @throws AbortException
	 */
	public function actionClose(int|string $id): never
	{
		$this->openedArticlesService->closeArticle($id);
		$this->redirect('Default:');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */
	protected function createComponentArticleForm(IArticleFormFactory $factory): ArticleForm
	{
		$control = $factory->create();
		if ($this->getParameter('id')) {
			$control->setArticle($this->getParameter('id'));
		}

		$control['form']->onSuccessSave[]         = function(BaseForm $form): never {
			$this->redirect('Articles:edit', $form->getCustomData('articleId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form): never {
			$this->redirect('Default:default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form): never {
			$this->redirect('Default:default');
		};

		return $control;
	}
}
