<?php declare(strict_types = 1);

namespace Blog\FrontModule\Model\Dao;

use Nette\SmartObject;

class Category
{
	use SmartObject;

	public ?string $layout        = null;
	public ?string $password      = null;
	public int     $articlesCount = 0;
	public ?int    $rootId        = null;
	public ?string $rootName      = null;
	public ?int    $lvl           = null;
	public ?int    $parentId      = null;
	public ?string $text          = null;

	public function __construct(public int $id, public string $lang, public string $title, public string $alias)
	{
	}

	public function getId(): int { return $this->id; }
}
