<?php declare(strict_types = 1);

namespace Blog\FrontModule\Model\Search;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Query\Parameter;
use Blog\FrontModule\Model\Articles;
use Contributte\Translation\Translator;
use Core\FrontModule\Model\Dao\SearchItemResult;
use Core\FrontModule\Model\Providers\ISearchItem;
use Core\FrontModule\Model\Search\BaseSearchItem;
use Gallery\FrontModule\Model\Albums;
use Navigations\Model\Entities\Navigation;

class ArticlesSearchItem extends BaseSearchItem implements ISearchItem
{
	final public const GROUP = 'blogArticle';

	/** @var Translator @inject */
	public Translator $translator;

	/** @var Articles @inject */
	public Articles $articlesService;

	/** @var Albums @inject */
	public Albums $albumsService;

	public function search(string $q): array
	{
		/** @var SearchItemResult[] $result */
		$result         = [];
		$navigationsAll = [];
		$categoryNavs   = [];

		// Vyhledání všech blog položek v menu
		foreach ($this->em->getRepository(Navigation::class)->createQueryBuilder('n')
			         ->select('n.id, nt.title, n.componentParams')
			         ->join('n.texts', 'nt', 'WITH', 'nt.lang = :lang AND nt.isPublished = 1')
			         ->where('n.componentType IN (:type)')
			         ->setParameters(new ArrayCollection([new Parameter('type', ['blog.navigation.blog', 'blog.navigation.category']), new Parameter('lang', $this->translator->getLocale())]))
			         ->getQuery()->getArrayResult() as $row) {
			$navigationsAll[$row['id']] = $row;
		}

		// Porovnání titulků
		foreach ($navigationsAll as $row) {
			foreach ($row['componentParams']['categories'] as $catId) {
				$categoryNavs[$catId] = $row['id'];
			}
		}

		// Vyhledání ve clanich
		$qb = $this->articlesService->getEr()->createQueryBuilder('a');
		$qb = $this->articlesService->setPublishedCriteria($qb, false);

		$articleIds = [];
		foreach ($qb->select('a.id')
			         ->andWhere(
				         'at.title LIKE :text OR at.alias LIKE :text OR at.introtext LIKE :text OR at.fulltext LIKE :text',
			         )
			         ->setParameter('text', "%$q%")
			         ->getQuery()->getArrayResult() as $row) {
			$articleIds[] = $row['id'];
		}

		foreach ($this->articlesService->getArticles($articleIds) as $id => $article) {
			$navId = $categoryNavs[$article->categoryId];

			if (!$navId) {
				continue;
			}

			$searchItem             = new SearchItemResult(self::GROUP, $article->title, $article->link);
			$searchItem->navigation = $this->navigations->getNavigation((int) $navId);
			$searchItem->params     = [
				'article' => $article,
			];

			$result[$id] = $searchItem;
		}

		return $result;
	}
}
