<?php declare(strict_types = 1);

namespace Blog\FrontModule\Presenters;

use Blog\FrontModule\Components\ArticlesList;
use Blog\FrontModule\Components\IArticlesListFactory;
use Blog\FrontModule\Model\Categories;
use Blog\FrontModule\Model\Dao\Category;
use Nette\DI\Attributes\Inject;
use Pages\FrontModule\Model\TemplatePages;
use Pages\Model\Paths;

class CategoriesPresenter extends BasePresenter
{
	#[Inject]
	public TemplatePages $templatePagesService;

	#[Inject]
	public Categories $categories;

	#[Inject]
	public Paths $pathsService;

	public ?Category $category = null;

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionCategory(int $id): void
	{
		$this['list']->setCategories([$id]);
		$category = $this->categories->get($id);

		$this->category           = $category;
		$this->template->category = $category;

		$tpId = $this->getActiveNavigation()->componentParams['tpCategory'];
		if ($tpId) {
			$templatePage = $this->templatePagesService->get((int) $tpId);

			if ($templatePage) {
				$this->template->templateTextValues = $templatePage->getTexts();
				$this->template->setFile($this->pathsService->getTemplatePagesFile($templatePage->getTemplate()));
			}
		}
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentList(IArticlesListFactory $factory): ArticlesList
	{
		$control = $factory->create();

		$control->onAnchor[] = function() use ($control) {
			$page = $control->getParameter('page');

			if ($page > 1) {
				$this['meta']->setMeta('robots', 'noindex,follow');
			}
		};

		return $control;
	}
}
