<?php declare(strict_types = 1);

namespace Blog\Model;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Lang\Langs;
use Nette\Caching\Cache;
use Nette\Caching\Storage;

class BlogCache
{
	final public const cacheNamespace = 'blog';

	protected Cache $cache;

	public function __construct(
		protected Storage                $storage,
		protected Langs                  $langs,
		protected EntityManagerDecorator $em,
	)
	{
		$this->cache = new Cache($storage, self::cacheNamespace);
	}

	public function getCache(): Cache { return $this->cache; }

	public function clearCache(?int $articleId = null): void
	{
		if ($articleId) {
			foreach ($this->langs->getLangs(false) as $lang) {
				$this->cache->remove('article/' . $articleId . '/' . $lang->getTag());
			}
		}

		foreach ($this->langs->getLangs(false) as $lang) {
			$this->cache->remove('featured:' . $lang->getTag());
		}

		foreach ($this->em->getConnection()->executeQuery("SELECT id FROM blog__category WHERE lvl = 0")->iterateAssociative() as $row) {
			foreach ($this->langs->getLangs(false) as $lang) {
				$this->cache->remove('forNavigation/' . $row['id'] . '/' . $lang->getTag());
			}
		}

		$this->cache->clean([Cache::Tags => [self::cacheNamespace]]);
		$this->cache->clean([Cache::Tags => ['getAll']]);
		$this->cache->clean([Cache::Tags => ['articleNavs']]);
		$this->cache->clean([Cache::Tags => ['articles']]);
	}
}
