<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'blog__article_in_category')]
#[ORM\Entity]
class ArticleInCategory
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Article::class, cascade: ['persist'], inversedBy: 'categories')]
	#[ORM\JoinColumn(name: 'id_article', referencedColumnName: 'id', onDelete: 'CASCADE')]
	protected Article $article;

	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Category::class, cascade: ['persist'])]
	#[ORM\JoinColumn(name: 'id_category', referencedColumnName: 'id', onDelete: 'CASCADE')]
	protected Category $category;

	public function __construct(Article $article, Category $category)
	{
		$this->article  = $article;
		$this->category = $category;
	}

	public function getArticle(): Article { return $this->article; }

	public function getCategory(): Category { return $this->category; }
}
