<?php declare(strict_types = 1);

namespace Blog\Model\Entities;

use Core\Model\Entities\TId;
use DateTimeInterface;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

#[ORM\Table(name: 'blog__article_hits')]
#[ORM\Entity]
class Hit
{
	use TId;

	#[ORM\ManyToOne(targetEntity: Article::class)]
	#[ORM\JoinColumn(name: 'article_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	public ?Article $article;

	#[ORM\Column(type: Types::INTEGER, options: ['unsigned' => true])]
	public int $shows;

	#[ORM\Column(type: Types::DATE_MUTABLE)]
	public ?DateTimeInterface $date = null;

	public function __construct(?Article $article, DateTimeInterface $date = null)
	{
		$this->article = $article;
		$this->shows   = 0;
		$this->date    = $date instanceof DateTime ? $date : new DateTime;
	}
}
