<?php declare(strict_types = 1);

namespace Blog\Model;

use Blog\Model\Entities\Article;
use Core\Model\Helpers\BaseService;

class MostRead extends BaseService
{
	public bool $useGa = false;

	public function __construct(protected Articles $articlesService)
	{
	}

	/**
	 * @return Article[]
	 */
	public function getMostRead(): array
	{
		$articles = [];
		$mostRead = $this->articlesService->getMostRead(4);
		$mostRead = array_map(static fn($article) => $article['articleId'], $mostRead);

		foreach ($mostRead as $id) {
			$article = $this->articlesService->getReference($id);

			if ($article) {
				$articles[] = $article;
			}

			if (count($articles) >= 4) {
				break;
			}
		}

		return $articles;
	}
}
