<?php declare(strict_types = 1);

namespace Blog\Model;

use Core\Model\Router\RouteHelper;
use Core\Model\Router\RouteList;

class RouterFactory
{
	public function __construct(protected RouteHelper $routeHelper)
	{
	}

	public function createRouter(): RouteList
	{
		$router = new RouteList;

		$front   = $router[] = new RouteList('Blog:Front');
		$front[] = $this->routeHelper->createRoute('/blog/preview', 'Articles:preview');
		$front[] = $this->routeHelper->createRoute('/blog/add-to-favourite', 'Articles:addToFavourite');
		$front[] = $this->routeHelper->createRoute('/blog/remove-from-favourite', 'Articles:removeFromFavourite');

		return $router;
	}
}
