<?php declare(strict_types = 1);

namespace Blog\Model\TemplateTextType;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Query\Parameter;
use Blog\FrontModule\Model\Articles as ArticlesService;
use Blog\FrontModule\Model\Categories as CategoriesService;
use Contributte\Translation\Translator;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\BaseContainer;
use Doctrine\ORM\Query\Expr\Join;

class ArticleFromCategory extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'articleFromCategory';

	public function __construct(
		protected ArticlesService   $articlesService,
		protected CategoriesService $categoriesService,
		protected Translator        $translator,
	)
	{
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$articles = ['' => null];

		$qb = $this->articlesService->getEr()->createQueryBuilder('a')
			->select('a.id, at.title, at.lang')
			->innerJoin('a.texts', 'at')
			->orderBy('a.id', 'DESC');

		if ($params['category']) {
			$qb->innerJoin('a.categories', 'c', Join::WITH, 'c.category = :cId')
				->setParameters(new ArrayCollection([new Parameter('cId', $params['category'])]));
		}

		foreach ($qb->getQuery()->getArrayResult() as $row) {
			if (!isset($articles[$row['id']]) || $row['lang'] == $this->translator->getLocale()) {
				$articles[$row['id']] = $row['title'];
			}
		}

		if (isset($params['multiple']) && $params['multiple'] == true) {
			unset($articles['']);
			$formContainer->addCheckboxList($this->getName(), $this->getTitle(), $articles);
		} else {
			$formContainer->addSelect($this->getName(), $this->getTitle(), $articles);
		}
	}

	public function render(array $params)
	{
		if ($params['multiple'] == true && is_array($this->getDefault())) {
			return $this->articlesService->getArticles($this->getDefault());
		}

		return $this->articlesService->get((int) $this->getDefault());
	}
}
