<?php declare(strict_types = 1);

namespace Blog\AdminModule\Model\Subscribers;

use Contributte\Translation\Translator;
use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Event\Event;
use Nette\Application\LinkGenerator;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class LoadEditorDataSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;
	protected Translator             $translator;
	protected LinkGenerator          $linkGenerator;

	public function __construct(
		EntityManagerDecorator $em,
		Translator             $translator,
		LinkGenerator          $linkGenerator
	)
	{
		$this->em            = $em;
		$this->translator    = $translator;
		$this->linkGenerator = $linkGenerator;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'core.content.loadEditorData' => 'loadEditorData',
		];
	}

	public function loadEditorData(Event $event): void
	{
		foreach ($this->em->getConnection()->executeQuery("SELECT at.article_id, at.title, at.text, at.lang FROM blog__article_text at
                                                 WHERE at.is_published = 1")->iterateAssociative() as $row) {
			$event->data['data'][] = [
				'module'      => 'Blog',
				'id'          => $row['article_id'],
				'title'       => $row['title'],
				'link'        => $this->linkGenerator->link('Blog:Admin:Articles:edit', ['id' => $row['article_id']]),
				'lang'        => $row['lang'],
				'content'     => $row['text'],
				'missingData' => [],
			];
		}
	}
}
