<?php declare(strict_types = 1);

namespace Blog\FrontModule\Components\Article;

use Blog\Model\Articles;
use Blog\Model\Entities\Article;
use Core\Model\UI\BaseControl;
use Core\Model\UI\FrontPresenter;

class Featured extends BaseControl
{
	protected ?Article $article = null;
	protected Articles $articlesService;

	public function __construct(Articles $articles)
	{
		$this->articlesService = $articles;

		$this->monitor(FrontPresenter::class, function() {
			$this->article = $this->articlesService->getFeatured();
		});
	}

	public function render(): void
	{
		if (!$this->article) {
			return;
		}

		$this->template->article = $this->article;
		$this->template->setFile($this->getTemplateFile());
		$this->template->render();
	}

	public function getArticle(): ?Article { return $this->article; }

}
