<?php declare(strict_types = 1);

namespace Blog\FrontModule\Components\Article;

use Blog\Model\MostRead;
use Core\Model\UI\BaseControl;

class MostReadControl extends BaseControl
{
	protected MostRead $mostReadService;

	public function __construct(MostRead $mostRead)
	{
		$this->mostReadService = $mostRead;
	}

	public function render(): void
	{
		try {
			$this->template->articles       = $this->mostReadService->getMostRead();
			$this->template->setFile(__DIR__ . '/MostReadControl.latte');
			$this->template->render();
		} catch(\Exception $e) {

		}
	}

}
